<?php
/**
 * SubscriptionsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.7.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * SubscriptionsApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SubscriptionsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'calculateResourceUsage' => [
            'application/json',
        ],
        'createCustomerSubscription' => [
            'application/json',
        ],
        'deleteSubscription' => [
            'application/json',
        ],
        'getCustomerSubscriptions' => [
            'application/json',
        ],
        'getSubscription' => [
            'application/json',
        ],
        'getSubscriptionBandwidthUsage' => [
            'application/json',
        ],
        'getSubscriptionsToParent' => [
            'application/json',
        ],
        'updateSubscription' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation calculateResourceUsage
     *
     * Re-Calculates all subscription resources
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['calculateResourceUsage'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\UsedResourcesFullListing
     */
    public function calculateResourceUsage($org_id, $subscription_id, string $contentType = self::contentTypes['calculateResourceUsage'][0])
    {
        list($response) = $this->calculateResourceUsageWithHttpInfo($org_id, $subscription_id, $contentType);
        return $response;
    }

    /**
     * Operation calculateResourceUsageWithHttpInfo
     *
     * Re-Calculates all subscription resources
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['calculateResourceUsage'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\UsedResourcesFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function calculateResourceUsageWithHttpInfo($org_id, $subscription_id, string $contentType = self::contentTypes['calculateResourceUsage'][0])
    {
        $request = $this->calculateResourceUsageRequest($org_id, $subscription_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch ($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\UsedResourcesFullListing',
                        $request,
                        $response,
                    );
            }



            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\UsedResourcesFullListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\UsedResourcesFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }


            throw $e;
        }
    }

    /**
     * Operation calculateResourceUsageAsync
     *
     * Re-Calculates all subscription resources
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['calculateResourceUsage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function calculateResourceUsageAsync($org_id, $subscription_id, string $contentType = self::contentTypes['calculateResourceUsage'][0])
    {
        return $this->calculateResourceUsageAsyncWithHttpInfo($org_id, $subscription_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation calculateResourceUsageAsyncWithHttpInfo
     *
     * Re-Calculates all subscription resources
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['calculateResourceUsage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function calculateResourceUsageAsyncWithHttpInfo($org_id, $subscription_id, string $contentType = self::contentTypes['calculateResourceUsage'][0])
    {
        $returnType = '\OpenAPI\Client\Model\UsedResourcesFullListing';
        $request = $this->calculateResourceUsageRequest($org_id, $subscription_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'calculateResourceUsage'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['calculateResourceUsage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function calculateResourceUsageRequest($org_id, $subscription_id, string $contentType = self::contentTypes['calculateResourceUsage'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling calculateResourceUsage'
            );
        }

        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling calculateResourceUsage'
            );
        }


        $resourcePath = '/orgs/{org_id}/subscriptions/{subscription_id}/calculate-resource-usage';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCustomerSubscription
     *
     * Create a subscriptions for a customer
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $customer_org_id The organization id of the organization&#39;s customer. (required)
     * @param  \OpenAPI\Client\Model\NewSubscription $new_subscription Subscription details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceId
     */
    public function createCustomerSubscription($org_id, $customer_org_id, $new_subscription, string $contentType = self::contentTypes['createCustomerSubscription'][0])
    {
        list($response) = $this->createCustomerSubscriptionWithHttpInfo($org_id, $customer_org_id, $new_subscription, $contentType);
        return $response;
    }

    /**
     * Operation createCustomerSubscriptionWithHttpInfo
     *
     * Create a subscriptions for a customer
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $customer_org_id The organization id of the organization&#39;s customer. (required)
     * @param  \OpenAPI\Client\Model\NewSubscription $new_subscription Subscription details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceId, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCustomerSubscriptionWithHttpInfo($org_id, $customer_org_id, $new_subscription, string $contentType = self::contentTypes['createCustomerSubscription'][0])
    {
        $request = $this->createCustomerSubscriptionRequest($org_id, $customer_org_id, $new_subscription, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch ($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\NewResourceId',
                        $request,
                        $response,
                    );
            }



            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\NewResourceId',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceId',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }


            throw $e;
        }
    }

    /**
     * Operation createCustomerSubscriptionAsync
     *
     * Create a subscriptions for a customer
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $customer_org_id The organization id of the organization&#39;s customer. (required)
     * @param  \OpenAPI\Client\Model\NewSubscription $new_subscription Subscription details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomerSubscriptionAsync($org_id, $customer_org_id, $new_subscription, string $contentType = self::contentTypes['createCustomerSubscription'][0])
    {
        return $this->createCustomerSubscriptionAsyncWithHttpInfo($org_id, $customer_org_id, $new_subscription, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCustomerSubscriptionAsyncWithHttpInfo
     *
     * Create a subscriptions for a customer
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $customer_org_id The organization id of the organization&#39;s customer. (required)
     * @param  \OpenAPI\Client\Model\NewSubscription $new_subscription Subscription details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomerSubscriptionAsyncWithHttpInfo($org_id, $customer_org_id, $new_subscription, string $contentType = self::contentTypes['createCustomerSubscription'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceId';
        $request = $this->createCustomerSubscriptionRequest($org_id, $customer_org_id, $new_subscription, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCustomerSubscription'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $customer_org_id The organization id of the organization&#39;s customer. (required)
     * @param  \OpenAPI\Client\Model\NewSubscription $new_subscription Subscription details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCustomerSubscriptionRequest($org_id, $customer_org_id, $new_subscription, string $contentType = self::contentTypes['createCustomerSubscription'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createCustomerSubscription'
            );
        }

        // verify the required parameter 'customer_org_id' is set
        if ($customer_org_id === null || (is_array($customer_org_id) && count($customer_org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_org_id when calling createCustomerSubscription'
            );
        }

        // verify the required parameter 'new_subscription' is set
        if ($new_subscription === null || (is_array($new_subscription) && count($new_subscription) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_subscription when calling createCustomerSubscription'
            );
        }


        $resourcePath = '/orgs/{org_id}/customers/{customer_org_id}/subscriptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($customer_org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_org_id' . '}',
                ObjectSerializer::toPathValue($customer_org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_subscription)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_subscription));
            } else {
                $httpBody = $new_subscription;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSubscription
     *
     * Delete subscription
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  bool|null $force force (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSubscription($org_id, $subscription_id, $force = false, string $contentType = self::contentTypes['deleteSubscription'][0])
    {
        $this->deleteSubscriptionWithHttpInfo($org_id, $subscription_id, $force, $contentType);
    }

    /**
     * Operation deleteSubscriptionWithHttpInfo
     *
     * Delete subscription
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  bool|null $force (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSubscriptionWithHttpInfo($org_id, $subscription_id, $force = false, string $contentType = self::contentTypes['deleteSubscription'][0])
    {
        $request = $this->deleteSubscriptionRequest($org_id, $subscription_id, $force, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }


            throw $e;
        }
    }

    /**
     * Operation deleteSubscriptionAsync
     *
     * Delete subscription
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  bool|null $force (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSubscriptionAsync($org_id, $subscription_id, $force = false, string $contentType = self::contentTypes['deleteSubscription'][0])
    {
        return $this->deleteSubscriptionAsyncWithHttpInfo($org_id, $subscription_id, $force, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSubscriptionAsyncWithHttpInfo
     *
     * Delete subscription
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  bool|null $force (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSubscriptionAsyncWithHttpInfo($org_id, $subscription_id, $force = false, string $contentType = self::contentTypes['deleteSubscription'][0])
    {
        $returnType = '';
        $request = $this->deleteSubscriptionRequest($org_id, $subscription_id, $force, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSubscription'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  bool|null $force (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSubscriptionRequest($org_id, $subscription_id, $force = false, string $contentType = self::contentTypes['deleteSubscription'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteSubscription'
            );
        }

        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling deleteSubscription'
            );
        }



        $resourcePath = '/orgs/{org_id}/subscriptions/{subscription_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $force,
            'force', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCustomerSubscriptions
     *
     * Get customer subscriptions
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $customer_org_id The organization id of the organization&#39;s customer. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerSubscriptions'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\SubscriptionsListing
     */
    public function getCustomerSubscriptions($org_id, $customer_org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getCustomerSubscriptions'][0])
    {
        list($response) = $this->getCustomerSubscriptionsWithHttpInfo($org_id, $customer_org_id, $offset, $limit, $sort_by, $sort_order, $contentType);
        return $response;
    }

    /**
     * Operation getCustomerSubscriptionsWithHttpInfo
     *
     * Get customer subscriptions
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $customer_org_id The organization id of the organization&#39;s customer. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerSubscriptions'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\SubscriptionsListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomerSubscriptionsWithHttpInfo($org_id, $customer_org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getCustomerSubscriptions'][0])
    {
        $request = $this->getCustomerSubscriptionsRequest($org_id, $customer_org_id, $offset, $limit, $sort_by, $sort_order, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch ($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\SubscriptionsListing',
                        $request,
                        $response,
                    );
            }



            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\SubscriptionsListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\SubscriptionsListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }


            throw $e;
        }
    }

    /**
     * Operation getCustomerSubscriptionsAsync
     *
     * Get customer subscriptions
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $customer_org_id The organization id of the organization&#39;s customer. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerSubscriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerSubscriptionsAsync($org_id, $customer_org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getCustomerSubscriptions'][0])
    {
        return $this->getCustomerSubscriptionsAsyncWithHttpInfo($org_id, $customer_org_id, $offset, $limit, $sort_by, $sort_order, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCustomerSubscriptionsAsyncWithHttpInfo
     *
     * Get customer subscriptions
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $customer_org_id The organization id of the organization&#39;s customer. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerSubscriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerSubscriptionsAsyncWithHttpInfo($org_id, $customer_org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getCustomerSubscriptions'][0])
    {
        $returnType = '\OpenAPI\Client\Model\SubscriptionsListing';
        $request = $this->getCustomerSubscriptionsRequest($org_id, $customer_org_id, $offset, $limit, $sort_by, $sort_order, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCustomerSubscriptions'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $customer_org_id The organization id of the organization&#39;s customer. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerSubscriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCustomerSubscriptionsRequest($org_id, $customer_org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getCustomerSubscriptions'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getCustomerSubscriptions'
            );
        }

        // verify the required parameter 'customer_org_id' is set
        if ($customer_org_id === null || (is_array($customer_org_id) && count($customer_org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_org_id when calling getCustomerSubscriptions'
            );
        }






        $resourcePath = '/orgs/{org_id}/customers/{customer_org_id}/subscriptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_by,
            'sortBy', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sortOrder', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($customer_org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customer_org_id' . '}',
                ObjectSerializer::toPathValue($customer_org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSubscription
     *
     * Get subscription
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Subscription
     */
    public function getSubscription($org_id, $subscription_id, string $contentType = self::contentTypes['getSubscription'][0])
    {
        list($response) = $this->getSubscriptionWithHttpInfo($org_id, $subscription_id, $contentType);
        return $response;
    }

    /**
     * Operation getSubscriptionWithHttpInfo
     *
     * Get subscription
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Subscription, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSubscriptionWithHttpInfo($org_id, $subscription_id, string $contentType = self::contentTypes['getSubscription'][0])
    {
        $request = $this->getSubscriptionRequest($org_id, $subscription_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch ($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Subscription',
                        $request,
                        $response,
                    );
            }



            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Subscription',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Subscription',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }


            throw $e;
        }
    }

    /**
     * Operation getSubscriptionAsync
     *
     * Get subscription
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSubscriptionAsync($org_id, $subscription_id, string $contentType = self::contentTypes['getSubscription'][0])
    {
        return $this->getSubscriptionAsyncWithHttpInfo($org_id, $subscription_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSubscriptionAsyncWithHttpInfo
     *
     * Get subscription
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSubscriptionAsyncWithHttpInfo($org_id, $subscription_id, string $contentType = self::contentTypes['getSubscription'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Subscription';
        $request = $this->getSubscriptionRequest($org_id, $subscription_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSubscription'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSubscriptionRequest($org_id, $subscription_id, string $contentType = self::contentTypes['getSubscription'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getSubscription'
            );
        }

        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling getSubscription'
            );
        }


        $resourcePath = '/orgs/{org_id}/subscriptions/{subscription_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSubscriptionBandwidthUsage
     *
     * Get subscription bandwidth
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionBandwidthUsage'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return int
     */
    public function getSubscriptionBandwidthUsage($org_id, $subscription_id, $refresh_cache = null, string $contentType = self::contentTypes['getSubscriptionBandwidthUsage'][0])
    {
        list($response) = $this->getSubscriptionBandwidthUsageWithHttpInfo($org_id, $subscription_id, $refresh_cache, $contentType);
        return $response;
    }

    /**
     * Operation getSubscriptionBandwidthUsageWithHttpInfo
     *
     * Get subscription bandwidth
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionBandwidthUsage'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of int, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSubscriptionBandwidthUsageWithHttpInfo($org_id, $subscription_id, $refresh_cache = null, string $contentType = self::contentTypes['getSubscriptionBandwidthUsage'][0])
    {
        $request = $this->getSubscriptionBandwidthUsageRequest($org_id, $subscription_id, $refresh_cache, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch ($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'int',
                        $request,
                        $response,
                    );
            }



            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'int',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'int',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }


            throw $e;
        }
    }

    /**
     * Operation getSubscriptionBandwidthUsageAsync
     *
     * Get subscription bandwidth
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionBandwidthUsage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSubscriptionBandwidthUsageAsync($org_id, $subscription_id, $refresh_cache = null, string $contentType = self::contentTypes['getSubscriptionBandwidthUsage'][0])
    {
        return $this->getSubscriptionBandwidthUsageAsyncWithHttpInfo($org_id, $subscription_id, $refresh_cache, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSubscriptionBandwidthUsageAsyncWithHttpInfo
     *
     * Get subscription bandwidth
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionBandwidthUsage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSubscriptionBandwidthUsageAsyncWithHttpInfo($org_id, $subscription_id, $refresh_cache = null, string $contentType = self::contentTypes['getSubscriptionBandwidthUsage'][0])
    {
        $returnType = 'int';
        $request = $this->getSubscriptionBandwidthUsageRequest($org_id, $subscription_id, $refresh_cache, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSubscriptionBandwidthUsage'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionBandwidthUsage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSubscriptionBandwidthUsageRequest($org_id, $subscription_id, $refresh_cache = null, string $contentType = self::contentTypes['getSubscriptionBandwidthUsage'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getSubscriptionBandwidthUsage'
            );
        }

        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling getSubscriptionBandwidthUsage'
            );
        }



        $resourcePath = '/orgs/{org_id}/subscriptions/{subscription_id}/bandwidth';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $refresh_cache,
            'refreshCache', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSubscriptionsToParent
     *
     * Get subscriptions to parent
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionsToParent'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\SubscriptionsListing
     */
    public function getSubscriptionsToParent($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getSubscriptionsToParent'][0])
    {
        list($response) = $this->getSubscriptionsToParentWithHttpInfo($org_id, $offset, $limit, $sort_by, $sort_order, $contentType);
        return $response;
    }

    /**
     * Operation getSubscriptionsToParentWithHttpInfo
     *
     * Get subscriptions to parent
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionsToParent'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\SubscriptionsListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSubscriptionsToParentWithHttpInfo($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getSubscriptionsToParent'][0])
    {
        $request = $this->getSubscriptionsToParentRequest($org_id, $offset, $limit, $sort_by, $sort_order, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch ($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\SubscriptionsListing',
                        $request,
                        $response,
                    );
            }



            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\SubscriptionsListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\SubscriptionsListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }


            throw $e;
        }
    }

    /**
     * Operation getSubscriptionsToParentAsync
     *
     * Get subscriptions to parent
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionsToParent'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSubscriptionsToParentAsync($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getSubscriptionsToParent'][0])
    {
        return $this->getSubscriptionsToParentAsyncWithHttpInfo($org_id, $offset, $limit, $sort_by, $sort_order, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSubscriptionsToParentAsyncWithHttpInfo
     *
     * Get subscriptions to parent
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionsToParent'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSubscriptionsToParentAsyncWithHttpInfo($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getSubscriptionsToParent'][0])
    {
        $returnType = '\OpenAPI\Client\Model\SubscriptionsListing';
        $request = $this->getSubscriptionsToParentRequest($org_id, $offset, $limit, $sort_by, $sort_order, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSubscriptionsToParent'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscriptionsToParent'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSubscriptionsToParentRequest($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getSubscriptionsToParent'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getSubscriptionsToParent'
            );
        }






        $resourcePath = '/orgs/{org_id}/subscriptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_by,
            'sortBy', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sortOrder', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateSubscription
     *
     * Update subscription
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  \OpenAPI\Client\Model\UpdateSubscription $update_subscription update_subscription (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateSubscription($org_id, $subscription_id, $update_subscription, string $contentType = self::contentTypes['updateSubscription'][0])
    {
        $this->updateSubscriptionWithHttpInfo($org_id, $subscription_id, $update_subscription, $contentType);
    }

    /**
     * Operation updateSubscriptionWithHttpInfo
     *
     * Update subscription
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  \OpenAPI\Client\Model\UpdateSubscription $update_subscription (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSubscriptionWithHttpInfo($org_id, $subscription_id, $update_subscription, string $contentType = self::contentTypes['updateSubscription'][0])
    {
        $request = $this->updateSubscriptionRequest($org_id, $subscription_id, $update_subscription, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }


            throw $e;
        }
    }

    /**
     * Operation updateSubscriptionAsync
     *
     * Update subscription
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  \OpenAPI\Client\Model\UpdateSubscription $update_subscription (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSubscriptionAsync($org_id, $subscription_id, $update_subscription, string $contentType = self::contentTypes['updateSubscription'][0])
    {
        return $this->updateSubscriptionAsyncWithHttpInfo($org_id, $subscription_id, $update_subscription, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateSubscriptionAsyncWithHttpInfo
     *
     * Update subscription
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  \OpenAPI\Client\Model\UpdateSubscription $update_subscription (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSubscriptionAsyncWithHttpInfo($org_id, $subscription_id, $update_subscription, string $contentType = self::contentTypes['updateSubscription'][0])
    {
        $returnType = '';
        $request = $this->updateSubscriptionRequest($org_id, $subscription_id, $update_subscription, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateSubscription'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  float $subscription_id The id of the subscription. (required)
     * @param  \OpenAPI\Client\Model\UpdateSubscription $update_subscription (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateSubscriptionRequest($org_id, $subscription_id, $update_subscription, string $contentType = self::contentTypes['updateSubscription'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateSubscription'
            );
        }

        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling updateSubscription'
            );
        }

        // verify the required parameter 'update_subscription' is set
        if ($update_subscription === null || (is_array($update_subscription) && count($update_subscription) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_subscription when calling updateSubscription'
            );
        }


        $resourcePath = '/orgs/{org_id}/subscriptions/{subscription_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_subscription)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_subscription));
            } else {
                $httpBody = $update_subscription;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);


        CE_Lib::log(4, $operationHost . $resourcePath . ($query ? "?{$query}" : ''));
        CE_Lib::log(4, $headers);
        CE_Lib::log(4, $httpBody);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
